--
--
--
function calcDiceRoll(base_dice_roll)

	local dice_roll = math.floor(base_dice_roll / DICE_ROLL_MOD)

	
	if (dice_roll < 1) then
		dice_roll = 1
	end
	
	log("_rpg_dice_", "Base:", base_dice_roll, "Mod:", DICE_ROLL_MOD, "Final:", dice_roll)
	
	return dice_roll
end
--
--       
--
function sayImpComment(merc)
	
	showComments(merc, merc.."_improvement_0"..tostring(math.random(4)), table_values.corner, 0, 0, 0, 0)

end 
--
--    
--
function processStatChange(merc, num_chances, stat, from_training)
	log("_rpg_process_", ">>>>>>>>>>>>>>>>ENTRANCE<<<<<<<<<<<<<<<<<<<")
	log("_rpg_process_", merc, "Chances:", num_chances, "Stat:", stat, "Mod:", RAISING_BRAKE)
	log("_rpg_process_", "> look in merc's log from now on")
	
	local chance 				= 0                								--base chance to raise stat is 0
	local subpoints_per_point 	= 25  											--subpoints that stat needs to collect to raise itself by 1
	local affected_by_wisdom 	= not(from_training)							--wisdom affects stat change by default
	local stat_value 			= getPersonParameter(merc, stat) 				--getting value of recieved stat
	local current_rating 		= math.floor(stat_value)     					--getting stat's current rating that is equal to value's floor (integer part)
	local new_stat_value 		= stat_value                       				--final stat value is equal to current stat value by default
	local wisdom 				= getPersonParameter(merc, "WISDOM") 			--getting merc's wisdom value
	local wisdom_rating 		= math.floor(wisdom)          					--getting wisdom's current rating
	local level 				= getPersonParameter(merc, "LEVEL")   			--getting merc's level value
	local level_rating 			= math.floor(level)            					--getting level's current rating
	local stat_gain 			= stat_value - current_rating     				--calculating current stat gain (float part)
	local wisdom_gain 			= wisdom - wisdom_rating        				--calculating current wisdom's gain (float part)
	local level_gain 			= level - level_rating           				--calculating current level's gain (float part)
	local subpoints_per_level 	= 10 * level            						--calculating subpoints for level
	local eff_level 			= level + (level_gain / subpoints_per_level)  	--calculating effective level for further calcs
--	local param_type			= 0	--0 - parameter, 1 - skill, 2 - level

	log(merc,"Stat:", stat, "Current rating:", current_rating, "Stat gain:", stat_gain, "Chances:", num_chances)

	if (num_chances == 0) then                        						--hollow run check

		log(merc, " ?!!!")

		return
	end

	if (current_rating <= 0) then                     						--stat can't be raised if it is at 0

		log(merc, "   !")

		return
	end

	if (stat == "AGILITY") then                       						--physical stats' changes are not affected by wisdom
		affected_by_wisdom = false
	end

	if (stat == "DEXTERITY") then                     						--physical stats' changes are not affected by wisdom
		affected_by_wisdom = false
	end

	if (stat == "STRENGTH") then                      						--physical stats' changes are not affected by wisdom
		affected_by_wisdom = false
	end
	
--	if ((stat == "MECHANICAL") or (stat == "EXPLOSIVES") or (stat == "MARKSMANSHIP") or (stat == "LEADERSHIP") or (stat == "MEDICAL")) then
--		param_type = 1
--	elseif (stat == "LEVEL") then
--		param_type = 2
--	end 

	for count = 1, num_chances do                     						--cycle for calcs (0;num_chances)

		local rnd = math.random(100)                  						--random number (0;100)

		log(merc, "Random:", rnd)

		if (stat ~= "LEVEL") then                     						--if stat is not LEVEL

			-- NON-experience level changes, actual Chance depends on CurrentRating
			-- Base Chance is '100 - CurrentRating'

			chance = 100 - (current_rating + (stat_gain * 100 / subpoints_per_point))  				
		else

			-- Experience level changes, actual Chance depends on level
			-- Base Chance is '100 - (10 * current level)'

			chance = 100 - 10 * (current_rating + (stat_gain * 100 / subpoints_per_point))  		
		end

		if ((chance > 0) and (affected_by_wisdom)) then
			chance = chance + (chance * (wisdom + (wisdom_gain / subpoints_per_point) - 50)) / 100 
		end

		if (chance > 99) then   											--chance can't be higher than 99%
			chance = 99
		end
		
		if (from_training == true) then
			chance = 0.5 * chance
		end
		
		if (chance < 1) then
			chance = 1
		end

		log(merc, "Chance:", chance)

		if (rnd <= chance) then     											--if we're lucky enough
			stat_gain = stat_gain + 0.01  									--rasing stat's gain by 1 point (it's 0.01 cause we are dealing with floats)

			if (stat ~= "LEVEL") then  										--if it's not a level change - we are giving some experience to level but only if it's not maxed out already

				if ((eff_level < 10) and ((level_gain * 100 + 1) < subpoints_per_level)) then  
					if (math.random() < 0.5) then
						log(merc, " ")
						
						setPersonParameter(merc, "LEVEL", level + 0.01)  		--rasing level's gain by 1 point
					end
				end
			end
		end
	end

	local pts_changed = stat_gain * 100 / (subpoints_per_point * RAISING_BRAKE)    			--calculating points to be added to stat

	if (stat == "LEVEL") then
		pts_changed = stat_gain * 100 / (subpoints_per_level)   				--level has a bit different raising system
	end

	if (pts_changed >= 1) then    											--we can't give more than 1 point change
		pts_changed = 1
	end

	if (pts_changed < 0.9999) then  						 				--that is needed due to use of floats
		pts_changed = stat_gain
	else
		pts_changed = 1
	end

	if (stat ~= "LEVEL") then

		if ((current_rating + pts_changed) > 100) then
			pts_changed = 100 - current_rating   							--stat can't go higher its max value
		end
	else

		if ((current_rating + pts_changed) > 10) then
			pts_changed = 10 - current_rating    							--level can't go higher too
		end
	end

	if ((current_rating + pts_changed) < 1) then
		pts_changed = 1 - current_rating  									--stat can't be lower than its min value
	end

	if (pts_changed ~= 0) then           									--if there's a stat change after all
		new_stat_value = current_rating + pts_changed   					--calculating new stat value
		
		if (stat_value < math.floor(new_stat_value)) then   				--if it's a 1 point raise
--			if (param_type == 0) then
--				sendMessage("parameter_improvement_event", NEW_MESSAGE)
--			elseif (param_type == 1) then
--				sendMessage("skill_improvement_event", NEW_MESSAGE)
--			else
--				sendMessage("level_improvement_event", NEW_MESSAGE)
--			end
			sayImpComment(merc)     										--merc tells that he is good at it
			
			if (math.random() > 0.5) then
				emo2000(merc, "good")
			end
			
			sound2D("ui/newbeep")
		end
		
		setPersonParameter(merc, stat, new_stat_value)  					--changing stat value
		
		if ((stat == "LEVEL") and (pts_changed == 1)) then
			showComments(merc, merc.."_salary_increase", table_values.corner, 0, 1, 5)
			local salary = getPersonParameter(merc, "SALARY")
			local new_salary = salary + Mercs[merc].salary * 0.10
			
			setPersonParameter(merc, "SALARY", new_salary)
			log(merc, "Raised salary. Was:", salary, "Now:", new_salary)
		end
		log(merc, " . :", stat_value, ":", new_stat_value)
	end
end
--
